---
title: Change your nameservers (Full setup) · Cloudflare DNS docs
description: If you want to use Cloudflare as your primary DNS provider and
  manage your DNS records, your domain should be using a full setup.
lastUpdated: 2025-10-23T07:57:47.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/
  md: https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/index.md
---

If you want to use Cloudflare as your primary DNS provider and manage your DNS records on Cloudflare, your domain should be using a full setup.

This means that you are using Cloudflare for your authoritative DNS nameservers.

## Before you begin

Before you update your domain nameservers, make sure that you:

* Already own a domain name (such as `example.com` or `cloudflare.com`).

Note

If you do not already have a [domain name](https://www.cloudflare.com/learning/dns/glossary/what-is-a-domain-name/), get one at-cost through [Cloudflare Registrar](https://dash.cloudflare.com/?to=/:account/domains/register).

All domains purchased through Cloudflare Registrar automatically use Cloudflare for authoritative DNS, which means you can skip the rest of this tutorial.

* Have previously created a [Cloudflare account](https://developers.cloudflare.com/fundamentals/account/create-account/).
* Disabled [DNSSEC](https://developers.cloudflare.com/dns/concepts/#dnssec) at your registrar (where you bought your domain name).

Provider-specific instructions

This is not an exhaustive list of how to update DS records in other providers, but the following links may be helpful:

* [DNSimple](https://support.dnsimple.com/articles/cloudflare-ds-record/)
* [Domaindiscount24](https://support.domaindiscount24.com/hc/articles/4409759478161)
* [DreamHost](https://help.dreamhost.com/hc/en-us/articles/219539467)
* [Dynadot](https://www.dynadot.com/help/question/set-DNSSEC)
* [Enom](https://support.enom.com/support/solutions/articles/201000065386)
* [Gandi](https://docs.gandi.net/en/domain_names/advanced_users/dnssec.html)
* [GoDaddy](https://www.godaddy.com/en-ph/help/add-a-ds-record-23865)
* [Hostinger](https://www.hostinger.com/support/3667267-how-to-use-dnssec-records-at-hostinger/)
* [Hover](https://support.hover.com/support/solutions/articles/201000064716)
* [InMotion Hosting](https://www.inmotionhosting.com/support/edu/cpanel/enable-dnssec-cloudflare/)
* [INWX](https://kb.inwx.com/en-us/3-nameserver/131)
* [Joker.com](https://joker.com/faq/books/jokercom-faq-en/page/dnssec)
* [Name.com](https://www.name.com/support/articles/205439058-managing-dnssec)
* [Namecheap](https://www.namecheap.com/support/knowledgebase/article.aspx/9722/2232/managing-dnssec-for-domains-pointed-to-custom-dns/)
* [NameISP](https://support.nameisp.com/knowledgebase/dns)
* [Namesilo](https://www.namesilo.com/support/v2/articles/domain-manager/ds-records)
* [OVH](https://help.ovhcloud.com/csm/en-dns-secure-domain-dnssec?id=kb_article_view\&sysparm_article=KB0051637)
* [Squarespace](https://support.squarespace.com/hc/articles/4404183898125-Nameservers-and-DNSSEC-for-Squarespace-managed-domains#toc-dnssec)
* [Registro.br](https://registro.br/tecnologia/dnssec/?secao=tutoriais-dns)
* [Porkbun](https://kb.porkbun.com/article/93-how-to-install-dnssec) (do not fill out **keyData**)
* [TransIP](https://www.transip.eu/knowledgebase/150-secure-domains-custom-nameservers-dnssec/)

Note

If your previous provider allows you to add DNSKEY records on the zone apex and use these records in responses to DNS queries, refer to this [migration tutorial](https://developers.cloudflare.com/dns/dnssec/dnssec-active-migration/) to learn how to migrate a zone with DNSSEC enabled.

## Add site to Cloudflare

In the Cloudflare dashboard, [add your domain](https://developers.cloudflare.com/fundamentals/manage-domains/add-site/).

If Cloudflare is unable to identify your domain as a registered domain, make sure you are using an existing [top-level domain](https://www.cloudflare.com/learning/dns/top-level-domain/) (`.com`, `.net`, `.biz`, or others).

Cloudflare requires your `apex domain` to be one level below a valid TLD defined in the [Public Suffix List (PSL)](https://github.com/publicsuffix/list/blob/master/public_suffix_list.dat). Enterprise customers can onboard lower-level subdomains using [Subdomain setup](https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/).

## Review DNS records

When you start using Cloudflare's nameservers for authoritative DNS and your zone is in a full setup, Cloudflare will become your primary DNS provider. This means that your DNS records in Cloudflare need to be accurate for your domain to work properly.

Cloudflare can [automatically scan for common records](https://developers.cloudflare.com/dns/zone-setups/reference/dns-quick-scan/) and add them to the [DNS zone](https://developers.cloudflare.com/dns/concepts/#zone) for you, or you can add records manually. These records show up under your domain on the [**DNS Records**](https://dash.cloudflare.com/?to=/:account/:zone/dns/records) page of the dashboard.



Note

If you add a zone via the [API](https://developers.cloudflare.com/api/resources/zones/methods/create/), you can manually invoke the quick scan with the [Scan DNS Records endpoint](https://developers.cloudflare.com/api/resources/dns/subresources/records/methods/scan/).

Since the quick scan is not guaranteed to find all existing DNS records, you need to review your records, paying special attention to the following:

* [Zone apex records (`example.com`)](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-zone-apex/)

  More about zone apex records

  Zone apex refers to the domain or subdomain that you are [adding to Cloudflare](https://developers.cloudflare.com/dns/concepts/#zone).

  Usually, the zone apex record makes your domain accessible by visitors. In this case, the necessary record type ([A, AAAA, or CNAME](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#ip-address-resolution)) and its content will depend on the provider that [hosts](https://developers.cloudflare.com/fundamentals/manage-domains/#host-your-domain) your website or application.

  If you are using Cloudflare Pages, refer to [Custom domains](https://developers.cloudflare.com/pages/configuration/custom-domains/).

  If you are using other providers, look for their guidance on how to connect domains managed on external DNS services. Then, make sure you have the records required by your hosting provider on your [DNS records table](https://developers.cloudflare.com/dns/manage-dns-records/#dns-records-table) at Cloudflare.

* [Subdomain records (`www.example.com` or `blog.example.com`)](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-subdomain/)

  More about subdomain records

  Most subdomains serve a specific purpose within the overall context of your website. For example, `blog.example.com` might be your blog, `support.example.com` could be your customer help portal, and `store.example.com` would be your e-commerce site.

  Even if you do not require specific subdomains, you might want to set up at least a subdomain record on `www`. It will usually point to the same content as what you have on the apex domain (`example.com`) or use a [redirect](https://developers.cloudflare.com/fundamentals/manage-domains/manage-subdomains/#redirect-a-subdomain-to-the-apex-domain). Having a subdomain DNS record on `www` helps guarantee that a visitor who types `www.` in front of your domain address can still find your website or application.

* [Email records](https://developers.cloudflare.com/dns/manage-dns-records/how-to/email-records/)

  More about email records

  Depending on your business needs, you can configure DNS records so that you can use your domain to receive emails, receive and send emails from your domain, or prevent others from sending emails on your behalf (spoofing).

  Below are some examples of what those DNS records might look like. The exact values for your DNS mail records depend on your email provider. If you have issues, review the [Troubleshooting](https://developers.cloudflare.com/dns/troubleshooting/email-issues/) and contact your email service provider to confirm your DNS records are correct.

  | Type | Name | Content | Proxy status | TTL |
  | - | - | - | - | - |
  | A | `mail` | `192.0.2.1` | DNS Only | Auto |
  | MX | `example.com` | `5 john.mx.example-server.test` | DNS Only | Auto |
  | TXT | `_dmarc` | `"v=DMARC1; p=reject; sp=...` | DNS Only | Auto |
  | TXT | `*._domainkey` | `"v=DKIM1; k=rsa; p=..."` | DNS Only | Auto |
  | TXT | `example.com` | `"v=spf1 ip4:..."` | DNS Only | Auto |

Note

If you activate your domain on Cloudflare *without* setting up the correct DNS records for your domain and subdomain, your visitors may experience [DNS\_PROBE\_FINISHED\_NXDOMAIN](https://developers.cloudflare.com/dns/troubleshooting/dns-probe-finished-nxdomain/) errors.

## Update your nameservers

Once you have added a domain (also known as a *zone*) to Cloudflare, that domain will receive two assigned authoritative nameservers.

Warning

If your domain is particularly sensitive to downtime, review our suggestions to [minimize downtime](https://developers.cloudflare.com/fundamentals/performance/minimize-downtime/).

### Get nameserver names

1. In the Cloudflare dashboard, go to the zone **Overview** page.

   [Go to **Overview**](https://dash.cloudflare.com/?to=/:account/:zone/)

2. Locate the nameserver names in **2. Replace with Cloudflare's nameservers**.

   ![Find nameserver names on the Overview page of your domain](https://developers.cloudflare.com/_astro/nameserver-names.ubREU1lB_17qcRW.webp)



1. Keep this window open while you perform the next step.

Note

Cloudflare automatically assigns nameservers to a domain and these assignments cannot be changed. For more details, refer to [Nameserver assignments](https://developers.cloudflare.com/dns/zone-setups/reference/nameserver-assignment/).

### Update your registrar

1. Log in to the admin account for your domain registrar. If you do not know your provider, use [ICANN Lookup](https://lookup.icann.org/).

Note

Depending on your use case, you may have to perform this step on the DNS records management of your domain parent zone, or at a domain reseller, instead. Refer to [Nameservers](https://developers.cloudflare.com/dns/nameservers/update-nameservers/#specific-processes) for details.

1. Remove your existing authoritative nameservers.

2. Add the nameservers provided by Cloudflare. If their names are not **copied exactly**, your DNS will not resolve correctly.

Provider-specific instructions

This is not an exhaustive list of provider-specific instructions, but the following links may be helpful:

* [Ionos](https://www.ionos.com/help/domains/using-your-own-name-servers/using-your-own-name-servers-for-a-domain/)
* [101Domain](https://help.101domain.com/kb/managing-name-server-records)
* [Amazon](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-name-servers-glue-records.html#domain-name-servers-glue-records-adding-changing)
* [Blacknight](https://help.blacknight.com/hc/en-us/articles/212512229-Changing-nameservers-in-cp-blacknight-com)
* [BlueHost](https://www.bluehost.com/help/article/custom-nameservers)
* [DirectNIC](https://directnic.com/knowledge/article/33:how%2Bdo%2Bi%2Bmodify%2Bname%2Bservers%2Bfor%2Bmy%2Bdomain%2Bname%253F)
* [DNSMadeEasy](http://www.dnsmadeeasy.com/support/faq/)
* [Domain.com](https://www.domain.com/help/article/domain-management-how-to-update-nameservers)
* [Dotster](https://www.dotster.com/help/article/domain-management-how-to-update-nameservers)
* [DreamHost](https://help.dreamhost.com/hc/en-us/articles/360038897151)
* [EasyDNS](https://kb.easydns.com/knowledge/settingchanging-nameservers/)
* [Enom](https://help.enom.com/hc/en-us/articles/115000486451-Nameservers-NS)
* [Fast Domain](https://www.fastdomain.com/hosting/help/transfer_client_start)
* [FlokiNET](https://billing.flokinet.is/index.php?rp=/knowledgebase/57/Nameserver-and-DNS-records.html)
* [Gandi](https://docs.gandi.net/en/domain_names/common_operations/changing_nameservers.html)
* [GoDaddy](https://www.godaddy.com/help/change-nameservers-for-your-domain-names-664)
* [HostGator](https://www.hostgator.com/help/article/changing-name-servers)
* [Hostico](https://hostico.ro/docs/setarea-nameserverelor-din-contul-de-client-hostico/)
* [HostMonster](https://my.hostmonster.com/cgi/help/222)
* [Hover](https://support.hover.com/support/solutions/articles/201000064742-changing-your-domain-nameservers)
* [Internetdbs](https://faq.internetbs.net/hc/en-gb/articles/4516921367837-How-to-update-Nameservers-for-a-domain)
* [iPage](https://www.ipage.com/help/article/domain-management-how-to-update-nameservers)
* [MelbourneIT](https://support.melbourneit.au/docs/how-do-i-manage-my-dns-on-cpanel)
* [Moniker](https://support.moniker.com/hc/en-gb/articles/10101271418653-How-to-update-Nameservers-for-a-domain)
* [Name.com](https://www.name.com/support/articles/205934457-registering-custom-nameservers)
* [Namecheap](https://www.namecheap.com/support/knowledgebase/article.aspx/767/10/how-can-i-change-the-nameservers-for-my-domain)
* [Network Solutions](https://www.networksolutions.com/manage-it/edit-nameservers.jsp)
* [OVH](https://docs.ovh.com/gb/en/domains/web_hosting_general_information_about_dns_servers/#step-2-edit-your-domains-dns-servers)
* [Porkbun](https://kb.porkbun.com/article/22-how-to-change-your-nameservers)
* [Rackspace](https://support.rackspace.com/how-to/rackspace-name-servers/)
* [Register](https://www.register.com/knowledge)
* [Squarespace](https://support.squarespace.com/hc/articles/4404183898125-Nameservers-and-DNSSEC-for-Squarespace-managed-domains#toc-open-the-domain-s-advanced-settings)
* [Site5](https://kb.site5.com/dns-2/custom-nameservers/)
* [Softlayer](https://cloud.ibm.com/docs/dns?topic=dns-add-edit-or-delete-custom-name-servers-for-a-domain)
* [Yola](https://helpcenter.yola.com/hc/articles/360012492660-Changing-your-name-servers)

Note

To avoid common issues, refer to our [Nameserver replacement checklist](https://developers.cloudflare.com/dns/zone-setups/full-setup/troubleshooting/).

### Verify changes

Wait up to 24 hours while your registrar updates your nameservers.

When your domain is **Active**:

* You will receive an email from Cloudflare.
* Your domain will have a [status](https://developers.cloudflare.com/dns/zone-setups/reference/domain-status/) of **Active** on the **Websites** page of your account.
* Online tools such as <https://www.whatsmydns.net/> will show your Cloudflare-assigned nameservers (most of these tools use cached query results, so it may take longer for them to show the updated nameservers).
* CLI commands will show your Cloudflare-assigned nameservers

```txt
*Linux/Unix*
dig <DOMAIN_NAME> +trace @1.1.1.1
dig <DOMAIN_NAME> +trace @8.8.8.8


*Windows*
nslookup <DOMAIN_NAME> 1.1.1.1
nslookup <DOMAIN_NAME> 8.8.8.8
```

Note

If you see unexpected results, refer to our [troubleshooting suggestions](https://developers.cloudflare.com/dns/zone-setups/full-setup/troubleshooting/) and check with your domain registrar.

## Re-enable DNSSEC

When you updated your nameservers, you should have also disabled DNSSEC at your registrar.

You should now [enable DNSSEC](https://developers.cloudflare.com/dns/dnssec/) to protect from domain spoofing.
