---
title: Redirect requests from one domain to another · Cloudflare Rules docs
description: Create a redirect rule to redirect all requests to a different
  domain, maintaining all functionality, except for the discontinued HTTP
  service (port 80).
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-another-domain/
  md: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-another-domain/index.md
---

In this example the original domain was replaced with a different domain. All functionality was maintained, except for the HTTP service (port 80) which was discontinued.

1. Create a Bulk Redirect List with the following URL redirect:

   * **Source URL**: `example.com/`
   * **Target URL**: `https://example.net/`
   * **Subpath matching**: Enabled
   * **Preserve query string**: Enabled

2. Create a Bulk Redirect Rule that enables this list.

This configuration will perform the following redirects:

| Request URL | URL after redirect |
| - | - |
| `http://example.com/` | `https://example.net/` |
| `https://example.com/` | `https://example.net/` |
| `https://example.com/my/path/to/page.htm` | `https://example.net/my/path/to/page.htm` |
| `https://example.com/search?q=term` | `https://example.net/search?q=term` |
